require "prefabutil"

local assets=
{
	Asset( "ANIM", "anim/monolithbadge.zip" ),
	Asset("IMAGE", "images/inventoryimages/monolithbadge.tex"),
	Asset("ATLAS", "images/inventoryimages/monolithbadge.xml"),
}

local function spider_update(inst)
		local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
		if owner and owner.components.leader then
			owner.components.leader:RemoveFollowersByTag("pig")
			local x,y,z = owner.Transform:GetWorldPosition()
			local ents = TheSim:FindEntities(x,y,z, TUNING.SPIDERHAT_RANGE, {"spider"})
			for k,v in pairs(ents) do
				if v.components.follower and not v.components.follower.leader and not owner.components.leader:IsFollower(v) and owner.components.leader.numfollowers < 15 then
					owner.components.leader:AddFollower(v)
				end
			end
		end
	end

local function spider_disable(inst)
		if inst.updatetask then
			inst.updatetask:Cancel()
			inst.updatetask = nil
		end
		local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
		if owner and owner.components.leader then
			
			if not owner:HasTag("spiderwhisperer") then 
				owner:RemoveTag("monster")

				for k,v in pairs(owner.components.leader.followers) do
					if k:HasTag("spider") and k.components.combat then
						k.components.combat:SuggestTarget(owner)
					end
				end
				owner.components.leader:RemoveFollowersByTag("spider")
			else
				owner.components.leader:RemoveFollowersByTag("spider", function(follower)
					if follower and follower.components.follower then
						if follower.components.follower:GetLoyaltyPercent() > 0 then
							return false
						else
							return true
						end
					end
				end)
			end

		end
	end
	
local function spider_enable(inst)
		local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
		if owner and owner.components.leader then
			owner.components.leader:RemoveFollowersByTag("pig")
			owner:AddTag("monster")
		end
		inst.updatetask = inst:DoPeriodicTask(0.5, spider_update, 1)
	end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "monolithbadge", "swap_body")
	
	if not owner:HasTag("monolith") then
	owner.components.talker:Say("I'm not worthy in the monolith's eyes.")
	end
	if owner:HasTag("monolith") then
	spider_enable(inst)
	end
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	if owner:HasTag("monolith") then
	spider_disable(inst)
	end
end



local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
        	
    inst.AnimState:SetBank("monolithbadge")
    inst.AnimState:SetBuild("monolithbadge")
    inst.AnimState:PlayAnimation("idle", false)
	
	MakeInventoryPhysics(inst)

	
	inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/monolithbadge.xml"
    inst.components.inventoryitem:SetOnDroppedFn( spider_disable )
    	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.NECK or EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
    return inst
end

STRINGS.RECIPE_DESC.MONOLITHBADGE = "Call your spider\nallies to aid you."

return Prefab( "common/inventory/monolithbadge", fnab, assets) 